package com.qboxus.tictic.activitesfragments

import android.content.Intent
import android.location.LocationManager
import android.os.Bundle
import android.view.View
import android.webkit.WebChromeClient
import android.webkit.WebView
import android.webkit.WebViewClient
import android.widget.ProgressBar
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import androidx.cardview.widget.CardView
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.location.LocationPermissionActivity
import com.qboxus.tictic.mainmenu.MainMenuActivity
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.PermissionUtils
import com.qboxus.tictic.simpleclasses.Variables

class WebviewActivity : AppCompatLocaleActivity(), View.OnClickListener {

    var progressBar: ProgressBar? = null
    var webView: WebView? = null
    var url: String? = "www.google.com"
    var title: String? = null
    var from: String? = null
    var titleTxt: TextView? = null
    var acceptBtn: CardView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        Functions.setLocale(
            Functions.getSharedPreference(this)
                .getString(Variables.APP_LANGUAGE_CODE, Variables.DEFAULT_LANGUAGE_CODE),
            this,
            javaClass,
            false
        )
        setContentView(R.layout.activity_webview)
        url = intent.getStringExtra("url")
        title = intent.getStringExtra("title")
        from = intent.getStringExtra("from")
        if (title == getString(R.string.promote_video)) {
            findViewById<View>(R.id.toolbar).visibility = View.GONE
        }
        Functions.printLog(Constants.tag, url)
        findViewById<View>(R.id.goBack).setOnClickListener(this)
        titleTxt = findViewById(R.id.title_txt)
        titleTxt!!.setText(title)
        webView = findViewById(R.id.webview)
        progressBar = findViewById(R.id.progress_bar)
        webView!!.setWebChromeClient(object : WebChromeClient() {
            override fun onProgressChanged(view: WebView, progress: Int) {
                if (progress >= 80) {
                    progressBar!!.setVisibility(View.GONE)
                }
            }
        })
        webView!!.getSettings().javaScriptEnabled = true
        webView!!.loadUrl(url!!)
        webView!!.setWebViewClient(object : WebViewClient() {
            override fun shouldOverrideUrlLoading(view: WebView, url: String): Boolean {
                view.loadUrl(url)
                if (url.equals("closePopup", ignoreCase = true)) {
                    super@WebviewActivity.onBackPressed()
                }
                return false
            }
        })
        if (from != null && from == "splash") {
            acceptBtn = findViewById(R.id.acceptBtn)
            acceptBtn!!.setOnClickListener(this)
            acceptBtn!!.setVisibility(View.VISIBLE)
        }

    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.goBack -> super@WebviewActivity.onBackPressed()
            R.id.acceptBtn -> {
                findViewById<View>(R.id.acceptTxt).visibility = View.GONE
                findViewById<View>(R.id.acceptProgress).visibility = View.VISIBLE
                Functions.getSettingsPreference(this).edit()
                    .putBoolean(Variables.IsPrivacyPolicyAccept, true).commit()

                var intent: Intent?=null
                if(checkCurrentLocationUpdates()) {
                     intent = Intent(this@WebviewActivity, MainMenuActivity::class.java)

                }else{
                     intent = Intent(this@WebviewActivity, LocationPermissionActivity::class.java)
                }

                startActivity(intent)
                overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
                finish()

            }
        }
    }


    private fun checkCurrentLocationUpdates() :Boolean{
        val takePermissionUtils = PermissionUtils(this, null)

        val locationManager =
            this?.getSystemService(AppCompatActivity.LOCATION_SERVICE) as LocationManager
        val GpsStatus = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)
        if (!GpsStatus) {

            return false

        } else if (!takePermissionUtils!!.isLocationPermissionGranted) {

            return false

        } else {

            return true
        }
    }

}
